<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormEditReview()
  ===================================================*/

  function ShowFormEditReview() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $review_id, $review, $rating, $date, $subject, $username, $title, $url, $category, $has_next, $has_prev;

    if ($dbConn->Lookup('count(*)', 'idx_review', "review_id > '$id' and status = 0")) {
      $has_next = 1;
    }
    if ($dbConn->Lookup('count(*)', 'idx_review', "review_id < '$id' and status = 0")) {
      $has_prev = 1;
    }

    $review_id = $id;

    $query = "select * from idx_review where review_id = '$id'";
    $result = $dbConn->Execute($query);

    if($result) {
      $link_id = $result->Fields('link_id');
      $review = htmlspecialchars($result->Fields('review'));
      $rating = $result->Fields('rating');
      $date = $result->Fields('date');
      $subject = htmlspecialchars($result->Fields('subject'));
      $username = $result->Fields('username');
    }

    $date = date("d-M-Y",@strtotime($date));

    $query = "select title, category_id, url from idx_link where link_id = '$link_id'";
    $result = $dbConn->Execute($query);

    if($result) {
      $title = $result->Fields('title');
      $url = $result->Fields('url');
      $cat_id = $result->Fields('category_id');
    }

    // show category path

    $category_obj = new clsCategory;

    $category_obj->table_name = "idx_category";
    $category_obj->link_table_name = "idx_link";
    $category_obj->separator = $category_separator;
    $category = $category_obj->GetCategoryPath($cat_id);

    $rating_list = "Excellent!,Very Good,Good,Fair,Poor";
    $rating_value = "5,4,3,2,1";

    $rating = ShowDropDown("rating",$rating_list,$rating_value,$rating);

    DisplayTemplate($admin_template_path . "review_validate_edit.html",
      "\$review_id,\$review,\$rating,\$date,\$subject,\$username,\$title,\$url,\$category,\$has_prev,\$has_next");
  }


  /*===================================================
    ProcessFormEditReview()
  ===================================================*/

  function ProcessFormEditReview() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path;

    // vars url & form
    global $id, $review_id, $subject, $review, $rating;

    // vars messages
    global $msg;

    // vars template
    global $message;

    // verify input

    if(empty($subject)) $error_msg = $msg["20145"];
    elseif(empty($review)) $error_msg = $msg["20146"];
    elseif(empty($rating)) $error_msg = $msg["20147"];

    if(empty($error_msg)) {

      $query = "update idx_review set
        subject = '$subject',
        review = '$review',
        rating = '$rating'
        where review_id = $review_id";

      $result = $dbConn->Execute($query);

      $message = $msg['20521'];

    }
    else $message = $error_msg;

    DisplayTemplate($admin_template_path . "message.html", "\$message");

  }


  /*===================================================
    ProcessFormEditApproveReview()
  ===================================================*/

  function ProcessFormEditApproveReview() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path;

    // vars url & form
    global $id, $review_id, $subject, $review, $rating;

    // vars messages
    global $msg;

    // vars template
    global $message, $back, $title;

    // verify input

    if(empty($subject)) $error_msg = $msg["20145"];
    elseif(empty($review)) $error_msg = $msg["20146"];
    elseif(empty($rating)) $error_msg = $msg["20147"];

    if(empty($error_msg)) {

      $query = "update idx_review set
        subject = '$subject',
        review = '$review',
        rating = '$rating'
        where review_id = $review_id";

      $result = $dbConn->Execute($query);

      // approve review

      $tpl = new Template();

      $links_obj = new clsLink;
      $links_obj->table_name = "idx_link";
      $links_obj->review_table_name = "idx_review";

      $query = "select link_id from idx_review where review_id = $review_id";
      $result = $dbConn->Execute($query);
      $lid = $result->Fields("link_id");

      $query = "select title from idx_link where link_id = '$lid'";
      $result = $dbConn->Execute($query);
      $title = $result->Fields("title");

      $links_obj->ApproveReview($review_id);

      $message .= $msg["20141"];
      $tpl->assign('title', $title);
      $message = $tpl->fetch('var:' . $message);

      // recalculate avg_review
      $links_obj->UpdateAvgReview($review_id);

      $back = "<a href=review_validate.php>Back</a>";

    }
    else $message = $error_msg;

    DisplayTemplate($admin_template_path . "message.html", "\$message,\$back");
  }


  /*===================================================
    ShowFormPrevEditReview()
  ===================================================*/

  function ShowFormPrevEditReview() {

    // vars global configuration
    global $dbConn;

    // vars url & form
    global $review_id;

    // vars messages
    global $msg;

    // vars template

    $query = "select review_id from idx_review
              where review_id < '$review_id'
                    and status = 0
              order by review_id desc
              limit 1";
    $result = $dbConn->Execute($query);
    $review_id = $result->Fields("review_id");

    Redirect("review_validate_edit.php?id=$review_id");
  }


  /*===================================================
    ShowFormNextEditReview()
  ===================================================*/

  function ShowFormNextEditReview() {

    // vars global configuration
    global $dbConn;

    // vars url & form
    global $review_id;

    // vars messages
    global $msg;

    // vars template

    $query = "select review_id from idx_review
              where review_id > '$review_id'
                    and status = 0
              order by review_id asc
              limit 1";
    $result = $dbConn->Execute($query);
    $review_id = $result->Fields("review_id");

    Redirect("review_validate_edit.php?id=$review_id");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    DisplayTemplate($admin_template_path . "header.html");
    ShowFormEditReview();
  }
  elseif ($pflag == 'edit') {
    DisplayTemplate($admin_template_path . "header.html");
    ProcessFormEditReview();
  }
  elseif ($pflag == 'editapprove') {
    DisplayTemplate($admin_template_path . "header.html");
    ProcessFormEditApproveReview();
  }
  elseif ($pflag == 'prev') {
    ShowFormPrevEditReview();
  }
  elseif ($pflag == 'next') {
    ShowFormNextEditReview();
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>